<?php $__env->startSection('page_title',__('Bill Service List')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Bill Service List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Bill Service List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Bill Service List'); ?></h6>
									<button type="button" class="btn btn-dark bulkAdd"
											data-target="#limit_charge"
											data-route="<?php echo e(route('bill.chargeLimit.add')); ?>"
											data-toggle="modal"><?php echo app('translator')->get('Add Bulk Limit and Charge'); ?></button>
								</div>

								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-striped table-hover align-items-center table-flush">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL.'); ?></th>
												<th><?php echo app('translator')->get('Category'); ?></th>
												<th><?php echo app('translator')->get('Code'); ?></th>
												<th><?php echo app('translator')->get('Type'); ?></th>
												<th><?php echo app('translator')->get('Country'); ?></th>
												<th><?php echo app('translator')->get('Charges'); ?></th>
												<th><?php echo app('translator')->get('Limit'); ?></th>
												<th colspan="2"><?php echo app('translator')->get('Action'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php if($services): ?>
												<?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e(++$key); ?></td>
														<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e(str_replace('_',' ',ucfirst($value->service))); ?></td>
														<td data-label="<?php echo app('translator')->get('Code'); ?>"><?php echo e(__($value->code)); ?></td>
														<td data-label="<?php echo app('translator')->get('Type'); ?>"><?php echo e(__($value->type)); ?></td>
														<td data-label="<?php echo app('translator')->get('Country'); ?>"><?php echo e(__($value->country)); ?></td>
														<td data-label="<?php echo app('translator')->get('Charges'); ?>"><span class="text-danger"><?php echo e($value->percent_charge); ?>%
															+ <?php echo e($value->fixed_charge); ?> <?php echo e($value->currency); ?></span></td>
														<td data-label="<?php echo app('translator')->get('Limit'); ?>"><span
																class="text-dark font-weight-bold"><?php echo e($value->min_amount); ?>

															- <?php echo e($value->max_amount); ?> <?php echo e($value->currency); ?></span></td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<button data-target="#limit_charge_edit" data-toggle="modal"
																	data-resource="<?php echo e(json_encode($value)); ?>"
																	data-re="<?php echo e(json_encode($countryList)); ?>"
																	data-route="<?php echo e(route('bill.chargeLimit.edit',$value->id)); ?>"
																	class="btn btn-sm btn-outline-primary editCharge"><i
																	class="fas fa-edit"></i> <?php echo app('translator')->get('Edit Limit and Charge'); ?>
															</button>
															<?php if($value->status == 0): ?>
																<button data-target="#status_change" data-toggle="modal"
																		data-route="<?php echo e(route('bill.status.change',$value->id)); ?>"
																		class="btn btn-sm btn-outline-success enableStatus">
																	<i
																		class="fas fa-check-circle"></i> <?php echo app('translator')->get('Enable'); ?>
																</button>
															<?php else: ?>
																<button data-target="#status_change" data-toggle="modal"
																		data-route="<?php echo e(route('bill.status.change',$value->id)); ?>"
																		class="btn btn-sm btn-outline-danger disableStatus">
																	<i
																		class="fas fa-times"></i> <?php echo app('translator')->get('Disable'); ?>
																</button>
															<?php endif; ?>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($services->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>

	
	<div id="status_change" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Status Change Confirmation'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="statusRoute">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div id="tag-body">
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>

	
	<div id="limit_charge" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Add Bulk Limit and Charges'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="formRoute">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div class="row">
							<div class="col-md-12">
								<label><?php echo app('translator')->get('Select Service'); ?></label>
								<select class="form-control" name="service" required>
									<option selected="" disabled="" value=""><?php echo app('translator')->get('Select Service'); ?></option>
									<?php if($categories): ?>
										<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option
												value="<?php echo e($category->service); ?>"><?php echo e(str_replace('_',' ',ucfirst($category->service))); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>
								</select>
								<?php $__errorArgs = ['service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-12">
								<label><?php echo app('translator')->get('Select Country'); ?></label>
								<select class="form-control changeCountry" name="country"
										data-re="<?php echo e(json_encode($countryList)); ?>" required>
									<option selected="" disabled="" value=""><?php echo app('translator')->get('Select Country'); ?></option>
									<?php if($countries): ?>
										<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e($country->country); ?>"><?php echo e($country->country); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>
								</select>
								<?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Percent Charge'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="percent_charge" class="form-control"
										   required>
									<div class="input-group-append">
										<span class="form-control">%</span>
									</div>
								</div>
								<?php $__errorArgs = ['percent_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Fixed Charge'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="fixed_charge" class="form-control" required>
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['fixed_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Minimum Amount'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="min_amount" class="form-control">
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['min_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Maximum Amount'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="max_amount" class="form-control">
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['max_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<input type="hidden" name="currency" class="hdCurrency" value="">
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Add'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>

	
	<div id="limit_charge_edit" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Edit Limit and Charges'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="formRouteEdit">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div class="row">
							<div class="col-md-12">
								<label><?php echo app('translator')->get('Select Service'); ?></label>
								<select class="form-control showService" name="service">
								</select>
								<?php $__errorArgs = ['service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-12">
								<label><?php echo app('translator')->get('Select Country'); ?></label>
								<select class="form-control showCountry" name="country">
								</select>
								<?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Percent Charge'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="percent_charge" class="form-control percent"
										   required>
									<div class="input-group-append">
										<span class="form-control">%</span>
									</div>
								</div>
								<?php $__errorArgs = ['percent_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Fixed Charge'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="fixed_charge" class="form-control fix"
										   required>
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['fixed_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
						</div>
						<div class="row mt-3">
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Minimum Amount'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="min_amount" class="form-control min">
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['min_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<div class="col-md-6">
								<label><?php echo app('translator')->get('Maximum Amount'); ?></label>
								<div class="input-group">
									<input type="number" step="0.001" name="max_amount" class="form-control max">
									<div class="input-group-append">
										<span class="form-control showCurrency"></span>
									</div>
								</div>
								<?php $__errorArgs = ['max_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger"><?php echo e($message); ?></span>
								<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<input type="hidden" name="currency" class="hdCurrency" value="">
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Update'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		'use strict'

		$(document).on('click', '.enableStatus', function () {
			$('#tag-body').html('');
			var route = $(this).data('route');
			$('.statusRoute').attr('action', route)
			$('#tag-body').append(`<p>Are you sure enable the service<p>`)
		});

		$(document).on('click', '.disableStatus', function () {
			$('#tag-body').html('');
			var route = $(this).data('route');
			$('.statusRoute').attr('action', route)
			$('#tag-body').append(`<p>Are you sure disable the service<p>`)
		});

		$(document).on('click', '.editCharge', function () {
			var route = $(this).data('route');
			var resource = $(this).data('resource');
			$('.formRouteEdit').attr('action', route)
			$('.showCountry').html('')
			$('.showService').html('')
			$('.percent').val(resource.percent_charge)
			$('.fix').val(resource.fixed_charge)
			$('.min').val(resource.min_amount)
			$('.max').val(resource.max_amount)
			$('.showCurrency').text(resource.currency)
			let replaceService = resource.service.replace('_', ' ')
			$('.showCountry').append(`<option value="${resource.country}">${resource.country}</option>`);
			$('.showService').append(`<option value="${resource.service}">${replaceService}</option>`);
			var country = $(this).data('re');
			currencCode(country, resource.country);
		});

		$(document).on('click', '.bulkAdd', function () {
			var route = $(this).data('route');
			$('.formRoute').attr('action', route)
		});

		$(document).on('change', '.changeCountry', function () {
			var country = $(this).data('re');
			var code = $(this).find(':selected').val()

			currencCode(country, code);
		})

		function currencCode(country, code) {
			Object.keys(country).forEach(key => {
				let singleCode = country[key].code;
				if (singleCode == code) {
					$('.showCurrency').text(country[key].iso_code)
					$('.hdCurrency').val(country[key].iso_code)
					return;
				}
			});
		}
	</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/bill_payment/service/index.blade.php ENDPATH**/ ?>