<?php $__env->startSection('page_title',__('Exchange Money')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Exchange Money'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Exchange Money'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('exchange.search')); ?>" method="get">
									<?php echo $__env->make('user.exchange.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Exchange Money'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('Exchange'); ?></th>
											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Charge'); ?></th>
											<th><?php echo app('translator')->get('Exchange Rate'); ?></th>
											<th><?php echo app('translator')->get('Exchange Amount'); ?></th>
											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Created time'); ?></th>
											<th><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $exchanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('Exchange'); ?>">
													<?php echo e(__(optional($value->fromWallet->currency)->code) ?? __('N/A')); ?>

													<i class="fa fa-exchange-alt text-indigo"></i> <?php echo e(__(optional($value->toWallet->currency)->code) ?? __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->amount)) .' '. __(optional(optional($value->fromWallet)->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Charge'); ?>"><?php echo e((getAmount($value->charge)) .' '. __(optional(optional($value->fromWallet)->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Exchange Rate'); ?>"><?php echo e((getAmount($value->exchange_rate)) .' '. __(optional(optional($value->toWallet)->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Exchange Amount'); ?>"><?php echo e((getAmount($value->received_amount)) .' '. __(optional(optional($value->toWallet)->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($value->status): ?>
														<span class="badge badge-info"><?php echo app('translator')->get('Completed'); ?></span>
													<?php else: ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
												<td data-label="<?php echo app('translator')->get('Action'); ?>">
													<?php if(!$value->status): ?>
														<a href="<?php echo e(route('exchange.confirm',$value->utr)); ?>" target="_blank" class="btn btn-sm btn-primary"><?php echo app('translator')->get('Confirm'); ?></a>
													<?php endif; ?>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($exchanges->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/exchange/index.blade.php ENDPATH**/ ?>