<?php $__env->startSection('page_title', __('Commission List')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link href="<?php echo e(asset('assets/dashboard/css/select2.min.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Commission List'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Commission List'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('admin.commission.search')); ?>" method="get">
									<?php echo $__env->make('admin.referralBonus.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Commission List'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('Profit From'); ?></th>
											<th><?php echo app('translator')->get('Profit To'); ?></th>

											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Level'); ?></th>
											<th><?php echo app('translator')->get('Title'); ?></th>

											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Transaction At'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $commissionEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($commissionEntries) + $key); ?></td>
												<td data-label="<?php echo app('translator')->get('Profit From'); ?>">
													<a href="<?php echo e(route('user.edit', $value->from_user)); ?>" class="text-decoration-none">
														<div class="d-lg-flex d-block align-items-center ">
															<div class="mr-3"><img src="<?php echo e(optional($value->sender)->profilePicture()??asset('assets/upload/boy.png')); ?>" alt="user"
																				   class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e(optional($value->sender)->name?? __('N/A')); ?>">
															</div>
															<div class="d-inline-flex d-lg-block align-items-center">
																<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($value->sender)->name?? __('N/A'),20)); ?></p>
																<span class="text-muted font-14 ml-1"><?php echo e('@'.optional($value->sender)->username?? __('N/A')); ?></span>
															</div>
														</div>
													</a>

												</td>
												<td data-label="<?php echo app('translator')->get('Profit To'); ?>">

													<a href="<?php echo e(route('user.edit', $value->to_user)); ?>" class="text-decoration-none">
														<div class="d-lg-flex d-block align-items-center ">
															<div class="mr-3"><img src="<?php echo e(optional($value->receiver)->profilePicture()??asset('assets/upload/boy.png')); ?>" alt="user"
																				   class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e(optional($value->receiver)->name?? __('N/A')); ?>">
															</div>
															<div class="d-inline-flex d-lg-block align-items-center">
																<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($value->receiver)->name?? __('N/A'),20)); ?></p>
																<span class="text-muted font-14 ml-1"><?php echo e('@'.optional($value->receiver)->username?? __('N/A')); ?></span>
															</div>
														</div>
													</a>

												</td>

												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->commission_amount)).' '.__(optional($value->currency)->code)); ?></td>

												<td data-label="<?php echo app('translator')->get('Level'); ?>"><?php echo e(__($value->level)); ?></td>

												<td data-label="<?php echo app('translator')->get('Title'); ?>"><?php echo e(__($value->title)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction At'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($commissionEntries->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).ready(function () {
			$('.select2-single').select2();
		})
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/referralBonus/index.blade.php ENDPATH**/ ?>