<?php $__env->startSection('page_title', __('SMS Control')); ?>

<?php $__env->startPush('extra_styles'); ?>
    <link href="<?php echo e(asset('assets/dashboard/css/jquery-ui.min.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('SMS Control'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('SMS Control'); ?></div>
			</div>
		</div>

		<div class="section-body">
			<div class="row mt-sm-4">
				<div class="col-12 col-md-4 col-lg-3">
					<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.sms'), 'suffix' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-12 col-md-8 col-lg-9">
					<div class="container-fluid" id="container-wrapper">
						<div class="row justify-content-md-center">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div class="card-body">
										<div class="table-responsive">
											<table class="table table-hover align-items-center table-borderless">
												<thead class="thead-light">
												<tr>
													<th> <?php echo app('translator')->get('SHORTCODE'); ?> </th>
													<th> <?php echo app('translator')->get('DESCRIPTION'); ?> </th>
												</tr>
												</thead>
												<tbody>
												<tr>
													<td>
														<pre><?php echo app('translator')->get('[[receiver]]'); ?></pre>
													</td>
													<td> <?php echo app('translator')->get("Receiver's number will replace here."); ?> </td>
												</tr>
												<tr>
													<td>
														<pre><?php echo app('translator')->get('[[message]]'); ?></pre>
													</td>
													<td><?php echo app('translator')->get("Application notification message will replace here."); ?></td>
												</tr>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php
							if (old()){
								$headerData = array_combine(old('headerDataKeys'),old('headerDataValues'));
								$paramData = array_combine(old('paramKeys'),old('paramValues'));
								$formData = array_combine(old('formDataKeys'),old('formDataValues'));
								$headerData = (empty(array_filter($headerData))) ? null : json_encode($headerData);
								$paramData = (empty(array_filter($paramData))) ? null : json_encode($paramData);
								$formData = (empty(array_filter($formData))) ? null : json_encode($formData);
							} else {
								$headerData = $smsControl->headerData;
								$paramData = $smsControl->paramData;
								$formData = $smsControl->formData;
							}
							$headerActive = false;
							$paramActive = false;
							$formActive = false;
							if ($errors->has('headerDataKeys.*') || $errors->has('headerDataValues.*')) {
								$headerActive = true;
							}elseif ($errors->has('paramKeys.*') || $errors->has('paramValues.*')) {
								$paramActive = true;
							} elseif ($errors->has('formDataKeys.*') || $errors->has('formDataValues.*')) {
								$formActive = true;
							} else {
								$headerActive = true;
							}
						?>
						<div class="row justify-content-md-center">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('SMS Configuration'); ?></h6>
									</div>
									<div class="card-body">
										<form action="<?php echo e(route('sms.config')); ?>" method="post">
											<?php echo csrf_field(); ?>
											<div class="row">
												<div class="col-md-4">
													<div class="form-group">
														<label for="actionMethod"><?php echo app('translator')->get('Method'); ?></label>
														<select name="actionMethod" id="actionMethod"
																class="form-control <?php $__errorArgs = ['actionMethod'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
															<option value="GET" <?php echo e((old('actionMethod',$smsControl->actionMethod) == 'GET') ? 'selected' : ''); ?>>
																GET
															</option>
															<option value="POST" <?php echo e((old('actionMethod',$smsControl->actionMethod) == 'POST') ? 'selected' : ''); ?> >
																POST
															</option>
														</select>
														<div class="invalid-feedback">
															<?php $__errorArgs = ['actionMethod'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="col-md-8">
													<div class="form-group">
														<label for="actionUrl"><?php echo app('translator')->get('URL'); ?></label>
														<input type="text" name="actionUrl"
																value="<?php echo e(old('actionUrl',$smsControl->actionUrl)); ?>"
																placeholder="<?php echo app('translator')->get('Enter request URL'); ?>"
																class="form-control <?php $__errorArgs = ['actionUrl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
														<div class="invalid-feedback">
															<?php $__errorArgs = ['actionUrl'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group">
														<label><?php echo app('translator')->get('SMS Notification'); ?></label>
														<div class="selectgroup w-100">
															<label class="selectgroup-item">
																<input type="radio" name="sms_notification" value="0"
																	   class="selectgroup-input" <?php echo e(old('sms_notification', $basicControl->sms_notification) == 0 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
															</label>
															<label class="selectgroup-item">
																<input type="radio" name="sms_notification" value="1"
																	   class="selectgroup-input" <?php echo e(old('sms_notification', $basicControl->sms_notification) == 1 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
															</label>
														</div>
														<?php $__errorArgs = ['sms_notification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
														<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
												<div class="col-md-4">
													<div class="form-group">
														<label><?php echo app('translator')->get('SMS Verification'); ?></label>
														<div class="selectgroup w-100">
															<label class="selectgroup-item">
																<input type="radio" name="sms_verification" value="0"
																	   class="selectgroup-input" <?php echo e(old('sms_verification', $basicControl->sms_verification) == 0 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
															</label>
															<label class="selectgroup-item">
																<input type="radio" name="sms_verification" value="1"
																	   class="selectgroup-input" <?php echo e(old('sms_verification', $basicControl->sms_verification) == 1 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
															</label>
														</div>
														<?php $__errorArgs = ['sms_verification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
														<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>

											<hr>

											<ul class="nav nav-tabs" id="myTab" role="tablist">
												<li class="nav-item">
													<a class="nav-link <?php echo e(($headerActive) ? 'active' : ''); ?>" id="headerData-tab"
														data-toggle="tab" href="#headerData" role="tab" aria-controls="headerData"
														aria-selected="<?php echo e(($headerActive) ? 'true' : 'false'); ?>"><?php echo app('translator')->get('Headers'); ?></a>
												</li>
												<li class="nav-item">
													<a class="nav-link <?php echo e(($paramActive) ? 'active' : ''); ?>" id="params-tab"
														data-toggle="tab" href="#params" role="tab" aria-controls="params"
														aria-selected="<?php echo e(($paramActive) ? 'true' : 'false'); ?>"><?php echo app('translator')->get('Params'); ?></a>
												</li>
												<li class="nav-item">
													<a class="nav-link <?php echo e(($formActive) ? 'active' : ''); ?>" id="formData-tab"
														data-toggle="tab" href="#formData" role="tab" aria-controls="contact"
														aria-selected="<?php echo e(($formActive) ? 'true' : 'false'); ?>"><?php echo app('translator')->get('Form Data'); ?></a>
												</li>
											</ul>
											<div class="tab-content" id="myTabContent">
												<div class="tab-pane fade <?php echo e(($headerActive) ? 'show active' : ''); ?>" id="headerData"
														role="tabpanel" aria-labelledby="headerData-tab">
													<label for="headerData"><?php echo app('translator')->get('Headers'); ?></label>
													<div class="headerDataWrapper">
														<?php if(is_null($headerData)): ?>
															<div class="row">
																<div class="col-md-4">
																	<div class="form-group">
																		<input type="text" name="headerDataKeys[]" value=""
																				placeholder="<?php echo app('translator')->get('Key'); ?>"
																				class="form-control headerDataKeys">
																	</div>
																</div>
																<div class="col-md-7">
																	<div class="form-group">
																		<input type="text" name="headerDataValues[]" value=""
																				placeholder="<?php echo app('translator')->get('Value'); ?>"
																				class="form-control form-control-sm">
																	</div>
																</div>
																<div class="col-md-1">
																	<div class="form-group">
																		<a href="javascript:void(0);"
																			class="btn btn-primary btn-sm addHeaderData"><i
																					class="fas fa-plus"></i></a>
																	</div>
																</div>
															</div>
														<?php else: ?>
															<?php $__currentLoopData = json_decode($headerData); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<div class="row">
																	<div class="col-md-4">
																		<div class="form-group">
																			<input type="text" name="headerDataKeys[]" value="<?php echo e($key); ?>"
																					placeholder="<?php echo app('translator')->get('Key'); ?>" autocomplete="off"
																					class="form-control headerDataKeys <?php $__errorArgs = ['headerDataKeys.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ["headerDataKeys.".$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-7">
																		<div class="form-group">
																			<input type="text" name="headerDataValues[]"
																					value="<?php echo e($value); ?>" placeholder="<?php echo app('translator')->get('Value'); ?>"
																					class="form-control <?php $__errorArgs = ['headerDataValues.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ["headerDataValues.".$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-1">
																		<div class="form-group">
																			<?php if($loop->first): ?>
																				<a href="javascript:void(0);"
																					class="btn btn-primary btn-sm addHeaderData"><i
																							class="fas fa-plus"></i></a>
																			<?php else: ?>
																				<a href="javascript:void(0);"
																					class="btn btn-danger btn-sm removeDiv"><i
																							class="fas fa-minus"></i></a>
																			<?php endif; ?>
																		</div>
																	</div>
																</div>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														<?php endif; ?>
													</div>
												</div>
												<div class="tab-pane fade <?php echo e(($paramActive) ? 'show active' : ''); ?>" id="params"
														role="tabpanel" aria-labelledby="params-tab">
													<label for="params"><?php echo app('translator')->get('Params'); ?></label>
													<div class="paramsWrapper">
														<?php if(is_null($paramData)): ?>
															<div class="row">
																<div class="col-md-4">
																	<div class="form-group">
																		<input type="text" name="paramKeys[]" value=""
																				placeholder="<?php echo app('translator')->get('Key'); ?>"
																				class="form-control form-control-sm">
																	</div>
																</div>
																<div class="col-md-7">
																	<div class="form-group">
																		<input type="text" name="paramValues[]" value=""
																				placeholder="<?php echo app('translator')->get('Value'); ?>"
																				class="form-control form-control-sm">
																	</div>
																</div>
																<div class="col-md-1">
																	<div class="form-group">
																		<a href="javascript:void(0);"
																			class="btn btn-primary btn-sm addParams"><i
																					class="fas fa-plus"></i></a>
																	</div>
																</div>
															</div>
														<?php else: ?>
															<?php $__currentLoopData = json_decode($paramData); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<div class="row">
																	<div class="col-md-4">
																		<div class="form-group">
																			<input type="text" name="paramKeys[]" value="<?php echo e($key); ?>"
																					placeholder="<?php echo app('translator')->get('Key'); ?>"
																					class="form-control <?php $__errorArgs = ['paramKeys.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ["paramKeys".$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-7">
																		<div class="form-group">
																			<input type="text" name="paramValues[]" value="<?php echo e($value); ?>"
																					placeholder="<?php echo app('translator')->get('Value'); ?>"
																					class="form-control <?php $__errorArgs = ['paramValues.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ["paramValues.".$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-1">
																		<div class="form-group">
																			<?php if($loop->first): ?>
																				<a href="javascript:void(0);"
																					class="btn btn-primary btn-sm addParams"><i
																							class="fas fa-plus"></i></a>
																			<?php else: ?>
																				<a href="javascript:void(0);"
																					class="btn btn-danger btn-sm removeDiv"><i
																							class="fas fa-minus"></i></a>
																			<?php endif; ?>
																		</div>
																	</div>
																</div>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														<?php endif; ?>
													</div>
												</div>

												<div class="tab-pane fade<?php echo e(($formActive) ? 'show active' : ''); ?>" id="formData"
														role="tabpanel" aria-labelledby="formData-tab">
													<label for="formData"><?php echo app('translator')->get('Form Data'); ?></label>
													<div class="formDataWrapper">
														<?php if(is_null($formData)): ?>
															<div class="row">
																<div class="col-md-4">
																	<div class="form-group">
																		<input type="text" name="formDataKeys[]" value=""
																				placeholder="<?php echo app('translator')->get('Key'); ?>"
																				class="form-control form-control-sm">
																	</div>
																</div>
																<div class="col-md-7">
																	<div class="form-group">
																		<input type="text" name="formDataValues[]" value=""
																				placeholder="<?php echo app('translator')->get('Value'); ?>"
																				class="form-control form-control-sm">
																	</div>
																</div>
																<div class="col-md-1">
																	<div class="form-group">
																		<a href="javascript:void(0);"
																			class="btn btn-primary btn-sm addFormData"><i
																					class="fas fa-plus"></i></a>
																	</div>
																</div>
															</div>
														<?php else: ?>
															<?php $__currentLoopData = json_decode($formData); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<div class="row">
																	<div class="col-md-4">
																		<div class="form-group">
																			<input type="text" name="formDataKeys[]" value="<?php echo e($key); ?>"
																					placeholder="<?php echo app('translator')->get('Key'); ?>"
																					class="form-control <?php $__errorArgs = ['formDataKeys.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ['formDataKeys.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-7">
																		<div class="form-group">
																			<input type="text" name="formDataValues[]"
																					value="<?php echo e($value); ?>" placeholder="<?php echo app('translator')->get('Value'); ?>"
																					class="form-control <?php $__errorArgs = ['formDataValues.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
																			<div class="invalid-feedback">
																				<?php $__errorArgs = ['formDataValues.'.$loop->index];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
																				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
																			</div>
																		</div>
																	</div>
																	<div class="col-md-1">
																		<div class="form-group">
																			<?php if($loop->first): ?>
																				<a href="javascript:void(0);"
																					class="btn btn-primary btn-sm addFormData"><i
																							class="fas fa-plus"></i></a>
																			<?php else: ?>
																				<a href="javascript:void(0);"
																					class="btn btn-danger btn-sm removeDiv"><i
																							class="fas fa-minus"></i></a>
																			<?php endif; ?>
																		</div>
																	</div>
																</div>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														<?php endif; ?>
													</div>
												</div>
											</div>
											<button type="submit" class="btn btn-primary btn-block btn-sm"><?php echo app('translator')->get('Save Changes'); ?></button>
										</form>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="paramHtml d-none">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group">
									<input type="text" name="paramKeys[]" value="" placeholder="<?php echo app('translator')->get('Key'); ?>"
											class="form-control form-control-sm">
								</div>
							</div>
							<div class="col-md-7">
								<div class="form-group">
									<input type="text" name="paramValues[]" value="" placeholder="<?php echo app('translator')->get('Value'); ?>"
											class="form-control form-control-sm">
								</div>
							</div>
							<div class="col-md-1">
								<div class="form-group">
									<a href="javascript:void(0)" class="btn btn-danger btn-sm removeDiv"><i class="fas fa-minus"></i></a>
								</div>
							</div>
						</div>
					</div>

					<div class="formDataHtml d-none">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group">
									<input type="text" name="formDataKeys[]" value="" placeholder="<?php echo app('translator')->get('Key'); ?>"
											class="form-control form-control-sm">
								</div>
							</div>
							<div class="col-md-7">
								<div class="form-group">
									<input type="text" name="formDataValues[]" value="" placeholder="<?php echo app('translator')->get('Value'); ?>"
											class="form-control form-control-sm">
								</div>
							</div>
							<div class="col-md-1">
								<div class="form-group">
									<a href="javascript:void(0)" class="btn btn-danger btn-sm removeDiv"><i class="fas fa-minus"></i></a>
								</div>
							</div>
						</div>
					</div>

					<div class="headerDataHtml d-none">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group">
									<input type="text" name="headerDataKeys[]" value="" placeholder="<?php echo app('translator')->get('Key'); ?>"
											class="form-control headerDataKeys">
								</div>
							</div>
							<div class="col-md-7">
								<div class="form-group">
									<input type="text" name="headerDataValues[]" value="" placeholder="<?php echo app('translator')->get('Value'); ?>"
											class="form-control form-control-sm">
								</div>
							</div>
							<div class="col-md-1">
								<div class="form-group">
									<a href="javascript:void(0)" class="btn btn-danger btn-sm removeDiv"><i class="fas fa-minus"></i></a>
								</div>
							</div>
						</div>
					</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
    <script src="<?php echo e(asset('assets/dashboard/js/jquery-ui.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict'
        $(document).ready(function () {
            $(document).on('click', '.addHeaderData', function () {
                let headerDataHtml = $('.headerDataHtml').html();
                $('.headerDataWrapper').append(headerDataHtml);
            });

            $(document).on('click', '.addFormData', function () {
                let formDataHtml = $('.formDataHtml').html();
                $('.formDataWrapper').append(formDataHtml);
            });

            $(document).on('click', '.addParams', function () {
                let paramHtml = $('.paramHtml').html();
                $('.paramsWrapper').append(paramHtml);
            });

            $(document).on('click', '.removeDiv', function (e) {
                e.preventDefault();
                $(this).closest('.row').remove();
            });

            let availableTags = ["Accept", "Accept-CH", "Accept-CH-Lifetime", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Patch", "Accept-Post", "Accept-Ranges", "Access-Control-Allow-Credentials", "Access-Control-Allow-Headers", "Access-Control-Allow-Methods", "Access-Control-Allow-Origin", "Access-Control-Expose-Headers", "Access-Control-Max-Age", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Age", "Allow", "Alt-Svc", "Authorization", "Cache-Control", "Clear-Site-Data", "Connection", "Content-Disposition", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-Range", "Content-Security-Policy", "Content-Security-Policy-Report-Only", "Content-Type", "Cookie", "Cookie2", "Cross-Origin-Embedder-Policy", "Cross-Origin-Opener-Policy", "Cross-Origin-Resource-Policy", "DNT", "DPR", "Date", "Device-Memory", "Digest", "ETag", "Early-Data", "Expect", "Expect-CT", "Expires", "Feature-Policy", "Forwarded", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Index", "Keep-Alive", "Large-Allocation", "Last-Modified", "Link", "Location", "NEL", "Origin", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Public-Key-Pins", "Public-Key-Pins-Report-Only", "Range", "Referer", "Referrer-Policy", "Retry-After", "Save-Data", "Sec-Fetch-Dest", "Sec-Fetch-Mode", "Sec-Fetch-Site", "Sec-Fetch-User", "Sec-WebSocket-Accept", "Server", "Server-Timing", "Set-Cookie", "Set-Cookie2", "SourceMap", "Strict-Transport-Security", "TE", "Timing-Allow-Origin", "Tk", "Trailer", "Transfer-Encoding", "Upgrade", "Upgrade-Insecure-Requests", "User-Agent", "Vary", "Via", "WWW-Authenticate", "Want-Digest", "Warning", "X-Content-Type-Options", "X-DNS-Prefetch-Control", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Proto", "X-Frame-Options", "X-XSS-Protection"];
            $(document).on('click', '.addHeaderData', function () {
                $(".headerDataKeys").autocomplete({
                    autoFocus: true,
                    source: function (request, response) {
                        var results = $.ui.autocomplete.filter(availableTags, request.term);
                        response(results.slice(0, 10));
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/control_panel/smsConfig.blade.php ENDPATH**/ ?>