<?php $__env->startSection('page_title', __('Security Questions')); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Security Questions'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Security Questions'); ?></div>
			</div>
		</div>

		<div class="section-body">
			<div class="row mt-sm-4">
				<div class="col-12 col-md-4 col-lg-3">
				   <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-12 col-md-8 col-lg-9">
					<div class="container-fluid" id="container-wrapper">
						<div class="row justify-content-md-center">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Security Questions'); ?></h6>
										<a href="<?php echo e(route('securityQuestion.create')); ?>" class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Add New'); ?></a>
									</div>
									<div class="card-body">
										<div class="table-responsive">
											<table class="table table-hover align-items-center table-flush">
												<thead class="thead-light">
												<tr>
													<th><?php echo app('translator')->get('Question'); ?></th>
													<th><?php echo app('translator')->get('Action'); ?></th>
												</tr>
												</thead>
												<tbody>
												<?php $__currentLoopData = $securityQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $securityQuestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('Question'); ?>"><?php echo e(__($securityQuestion->question)); ?></td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<a href="<?php echo e(route('securityQuestion.edit', $securityQuestion)); ?>" class="btn btn-sm btn-outline-primary">
																<i class="fas fa-edit"></i>
																<?php echo app('translator')->get('Edit'); ?>
															</a>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/securityQuestion/index.blade.php ENDPATH**/ ?>