
    <!-- Navbar || Top-bar -->
    <header class="bg--section">
        <div class="navbar-section">
            <div class="container">
                <div class="navbar-wrapper">
                    <div class="logo">
                        <a href="<?php echo e(route('home')); ?>">
							<img src="<?php echo e(getFile(config('location.logo.path').'logo.png')); ?>"
							alt="<?php echo app('translator')->get(basicControl()->site_title); ?>">
                        </a>
                    </div>
                    <div class="d-lg-none ms-auto me-3">
                        <div class="lang-change">
							<select class="form-control selectLanguage">
								<?php $__currentLoopData = $getLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e(route('set.language',$language->short_name)); ?>" <?php echo e(session()->get('lang') == $language->short_name ? 'selected' : ''); ?>>
										<?php echo app('translator')->get($language->name); ?>
									</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
                        </div>
                    </div>
                    <div class="nav-toggle d-lg-none">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>

                    <div class="nav-menu-area">
                        <div class="menu-close text--danger d-lg-none">
                            <i class="las la-times"></i>
                        </div>
                        <ul class="nav-menu">
                            <li>
                                <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About'); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('faq')); ?>"><?php echo app('translator')->get('FAQ'); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                            </li>

                            <li class="d-none d-lg-block ms-lg-5">
                                <div class="lang-change">
									<select class="form-control selectLanguage">
										<?php $__currentLoopData = $getLanguages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<option value="<?php echo e(route('set.language',$language->short_name)); ?>" <?php echo e(session()->get('lang') == $language->short_name ? 'selected' : ''); ?>>
												<?php echo app('translator')->get($language->name); ?>
											</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </li>
                            <li>
								<?php if(Auth::check()): ?>
									<a href="javascript:void(0)" class="ms-lg-3 cmn--btn"><?php echo app('translator')->get('Dashboard'); ?></a>
									<ul class="sub-nav">
										<li>
											<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
										</li>
										<li>
											<a href="<?php echo e(route('user.profile')); ?>"><?php echo app('translator')->get('Profile'); ?></a>
										</li>
										<li>
											<a type="button" data-bs-toggle="modal" data-bs-target="#logoutModal">
												<?php echo app('translator')->get('Logout'); ?>
											</a>
										</li>
									</ul>
								<?php else: ?>
									<a href="<?php echo e(route('login')); ?>" class="ms-lg-3 cmn--btn"><?php echo app('translator')->get('Login Now'); ?></a>
								<?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </header>


	<!-- Start Logout Modal -->
	<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title text--base" id="logoutModalLabel"><?php echo app('translator')->get('Confirmation !'); ?></h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<?php echo app('translator')->get('Are you sure you want to logout?'); ?>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
				<a href="<?php echo e(route('logout')); ?>" type="button" class="btn cutombutton" onclick="event.preventDefault();
				document.getElementById('logout-form').submit();"><?php echo app('translator')->get('Logout'); ?></a>

			<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
				<?php echo csrf_field(); ?>
			</form>
			</div>
			</div>
		</div>
	</div>
	<!-- End Logout Modal -->

    <!-- Navbar || Top-bar -->
<?php /**PATH E:\xamp\htdocs\pay_secure_update\resources\views/frontend/layouts/topbar.blade.php ENDPATH**/ ?>