<?php $__env->startSection('page_title',__('Product Details')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Product Details'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Product Details'); ?></div>
				</div>
			</div>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Product Details'); ?></h6>
									<a href="<?php echo e(route('admin.product.list')); ?>"
									   class="btn btn-primary"><?php echo app('translator')->get('Back'); ?></a>
								</div>
								<div class="card-body">
									<form>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="Store"><?php echo app('translator')->get('Store'); ?></label>
													<select name="store[]"
															class="form-select form-control"
															id="selectStore"
															multiple="multiple">
														<?php $__empty_1 = true; $__currentLoopData = $product->productStores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productStore): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
															<option
																selected><?php echo e(optional($productStore->store)->name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
														<?php endif; ?>
													</select>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Category"><?php echo app('translator')->get('Category'); ?></label>
													<select name="category"
															class="form-control form-control-sm">
														<option value=""><?php echo e(optional($product->category)->name); ?></option>
													</select>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Product Name"><?php echo app('translator')->get('Product Name'); ?></label>
													<input type="text" value="<?php echo e($product->name); ?>"
														   name="name"
														   class="form-control"
														   autocomplete="off" readonly>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="Price"><?php echo app('translator')->get('Price'); ?></label>
													<div class="input-group">
														<input type="text" value="<?php echo e($product->price); ?>"
															   name="price"
															   class="form-control"
															   autocomplete="off" readonly>
														<div class="input-group-prepend">
															<span
																class="form-control currencyCode"><?php echo e(optional($product->user->storeCurrency)->code); ?> </span>
														</div>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Attribute Name"><?php echo app('translator')->get('Attribute Name'); ?></label>
													<select
														class="form-select form-control <?php $__errorArgs = ['attributes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
														id="select"
														multiple="multiple">
														<?php $__currentLoopData = $product->productAttrs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productAttr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option
																selected><?php echo e(optional($productAttr->attribute)->name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="SKU"><?php echo app('translator')->get('SKU'); ?></label>
													<input type="text" value="<?php echo e($product->sku); ?>"
														   name="sku"
														   class="form-control"
														   autocomplete="off" readonly>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="Tag"><?php echo app('translator')->get('Tag'); ?></label>
													<input type="text" value="<?php echo e($product->tag); ?>"
														   name="tag"
														   class="form-control"
														   autocomplete=" off" readonly>
												</div>
											</div>
											<div class="col-md-4">
												<label><?php echo app('translator')->get('Status'); ?></label>
												<div class="selectgroup w-100">
													<label class="selectgroup-item">
														<input type="radio" name="status"
															   value="0"
															   class="selectgroup-input" <?php echo e($product->status == 0 ? 'checked':''); ?>>
														<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
													</label>
													<label class="selectgroup-item">
														<input type="radio" name="status"
															   value="1"
															   class="selectgroup-input" <?php echo e($product->status == 1 ? 'checked':''); ?>>
														<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
													</label>
												</div>
											</div>
										</div>
										<div class="row addedField">
											<div class="col-sm-12 col-md-4 image-column mb-4">
												<label><?php echo app('translator')->get('Thumbnail Image'); ?></label>
												<div class="form-group position-relative">
													<div class="image-input z0">
														<label for="image-upload" id="image-label"><i
																class="fas fa-upload"></i></label>
														<img id="image_preview_container" class="preview-image"
															 src="<?php echo e(getFile(config('location.product.path').$product->thumbnail)); ?>"
															 alt="<?php echo app('translator')->get('preview image'); ?>">

													</div>
												</div>
											</div>
											<?php $__empty_1 = true; $__currentLoopData = $product->productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<div class="col-sm-12 col-md-4 image-column mb-4">
													<label><?php echo app('translator')->get('Product Image'); ?></label>
													<div class="form-group position-relative">
														<div class="image-input z0">
															<label for="image-upload" id="image-label"><i
																	class="fas fa-upload"></i></label>
															<img id="image_preview_container" class="preview-image"
																 src="<?php echo e(getFile(config('location.product.path').$image->image)); ?>"
																 alt="<?php echo app('translator')->get('preview image'); ?>">
														</div>
													</div>
												</div>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<?php endif; ?>
										</div>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label
														for="Description"><?php echo app('translator')->get('Description'); ?></label>
													<textarea
														class="form-control summernote"
														name="description"
														rows="5"><?php echo e($product->description); ?></textarea>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label
														for="Description"><?php echo app('translator')->get('Instruction'); ?></label>
													<textarea
														class="form-control summernote"
														name="instruction"
														rows="5"><?php echo e($product->instruction); ?></textarea>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
	<?php echo $__env->make('user.store.product.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/modules/summernote/summernote-bs4.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/store/css/bootstrap-select.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/modules/summernote/summernote-bs4.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/store/js/bootstrap-select.min.js')); ?>"></script>
	<script>
		'use strict';
		$(document).ready(function () {
			$(function () {
				$('#select').selectpicker();
			});
			$(function () {
				$('#selectStore').selectpicker();
			});
		});
	</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/store/product/productView.blade.php ENDPATH**/ ?>