<?php $__env->startSection('page_title', __('User profile')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('User profile'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('User profile'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid user-profile" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-lg-7">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<div class="media custom--media flex-wrap d-flex flex-row justify-content-center">
										<div class="mr-2">
											<img class="align-self-start mr-3 img-profile-view img-thumbnail"
												 src="<?php echo e($user->profilePicture()); ?>" alt="<?php echo e(__($user->name)); ?>">
										</div>
										<div class="media-body">
											<h5 class="mt-0 font-weight-bold text-primary"><?php echo e(__($user->name)); ?></h5>
											<p>
												<i class="fas fa-user"></i> <?php echo e(__($user->username)); ?> <br>
												<i class="fas fa-mobile-alt"></i> <?php echo e(__($userProfile->phone)); ?> <br>
												<i class="fas fa-envelope"></i> <?php echo e(__( $user->email)); ?> <br>
											</p>
										</div>
									</div>
								</div>
								<div class="card-body">
									<form method="post" action="<?php echo e(route('user.edit',$user)); ?>"
										  enctype="multipart/form-data">
										<?php echo csrf_field(); ?>
										<div class="row">
											<div class="col-md-6">
												<div class="form-group">
													<label for="username"><?php echo app('translator')->get('Username'); ?></label>
													<input type="text" name="username"
														   placeholder="<?php echo app('translator')->get('Username of uesr'); ?>"
														   value="<?php echo e(old('username',$user->username)); ?>"
														   class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="email"><?php echo app('translator')->get('E-Mail'); ?></label>
													<input type="text" name="email"
														   placeholder="<?php echo app('translator')->get('User email address'); ?>"
														   value="<?php echo e(old('email',$user->email)); ?>"
														   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="name"><?php echo app('translator')->get('Name'); ?></label>
													<input type="text" name="name" placeholder="<?php echo app('translator')->get('User full name'); ?>"
														   value="<?php echo e(old('name',$user->name)); ?>"
														   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="city"><?php echo app('translator')->get('City'); ?></label>
													<input type="text" name="city" placeholder="<?php echo app('translator')->get('User city'); ?>"
														   value="<?php echo e(old('city',$userProfile->city )); ?>"
														   class="form-control <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="form-group">
													<label for="phone"><?php echo app('translator')->get('Phone'); ?></label>
													<div class="input-group-sm media">
														<div class="input-group-prepend w-100">
															<select name="phone_code"
																	class="form-control-sm country_code w-100">
																<?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option
																		value="<?php echo e($value['phone_code']); ?>"<?php echo e($userProfile->phone_code == $value['phone_code'] ? 'selected' : ''); ?>>
																		<?php echo e(__($value['phone_code'])); ?>

																		<strong>(<?php echo e(__($value['name'])); ?>)</strong>
																	</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
														<input type="text" name="phone" class="form-control"
															   value="<?php echo e(old('phone',$userProfile->phone)); ?>"
															   placeholder="<?php echo app('translator')->get('User Phone Number'); ?>">
													</div>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group search-currency-dropdown">
													<label for="language"><?php echo app('translator')->get('Language'); ?>
														<i class="fas fa-info-circle" data-toggle="tooltip"
														   data-placement="top"
														   title="<?php echo app('translator')->get('Select language to get notification on preferred language'); ?>"></i>
													</label>
													<select name="language"
															class="form-control <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
														<?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option
																value="<?php echo e($language->id); ?>" <?php echo e(old('language', $user->language_id) == $language->id ? 'selected' : ''); ?>>
																<?php echo e(__($language->name)); ?>

															</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="state"><?php echo app('translator')->get('State'); ?></label>
													<input type="text" name="state" placeholder="<?php echo app('translator')->get('User state'); ?>"
														   value="<?php echo e(old('state',$userProfile->state)); ?>"
														   class="form-control <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="password"><?php echo app('translator')->get('Password'); ?></label>
													<input type="password" name="password"
														   placeholder="<?php echo app('translator')->get('User password'); ?>"
														   value="<?php echo e(old('password')); ?>"
														   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="user_pin"><?php echo app('translator')->get('User Pin'); ?></label>
													<input type="password" name="security_pin "
														   placeholder="<?php echo app('translator')->get('User pin'); ?>"
														   value="<?php echo e(old('security_pin ')); ?>"
														   class="form-control <?php $__errorArgs = ['security_pin '];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['security_pin '];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label><?php echo app('translator')->get('Email Verification'); ?></label>
													<div class="selectgroup w-100">
														<label class="selectgroup-item">
															<input type="radio" name="email_verification" value="0"
																   class="selectgroup-input" <?php echo e(old('email_verification', $user->email_verification) == 0 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Unverified'); ?></span>
														</label>
														<label class="selectgroup-item">
															<input type="radio" name="email_verification" value="1"
																   class="selectgroup-input" <?php echo e(old('email_verification', $user->email_verification) == 1 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Verified'); ?></span>
														</label>
													</div>
													<?php $__errorArgs = ['email_verification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<span class="text-danger" role="alert">
														<strong><?php echo e(__($message)); ?></strong>
													</span>
													<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label><?php echo app('translator')->get('SMS Verification'); ?></label>
													<div class="selectgroup w-100">
														<label class="selectgroup-item">
															<input type="radio" name="sms_verification" value="0"
																   class="selectgroup-input" <?php echo e(old('sms_verification', $user->sms_verification) == 0 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Unverified'); ?></span>
														</label>
														<label class="selectgroup-item">
															<input type="radio" name="sms_verification" value="1"
																   class="selectgroup-input" <?php echo e(old('sms_verification', $user->sms_verification) == 1 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Verified'); ?></span>
														</label>
													</div>
													<?php $__errorArgs = ['sms_verification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<span class="text-danger" role="alert">
														<strong><?php echo e(__($message)); ?></strong>
													</span>
													<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label><?php echo app('translator')->get('User Status'); ?></label>
													<div class="selectgroup w-100">
														<label class="selectgroup-item">
															<input type="radio" name="status" value="0"
																   class="selectgroup-input" <?php echo e(old('status', $user->status) == 0 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Suspend'); ?></span>
														</label>
														<label class="selectgroup-item">
															<input type="radio" name="status" value="1"
																   class="selectgroup-input" <?php echo e(old('status', $user->status) == 1 ? 'checked' : ''); ?>>
															<span class="selectgroup-button"><?php echo app('translator')->get('Active'); ?></span>
														</label>
													</div>
													<?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
													<span class="text-danger" role="alert">
														<strong><?php echo e(__($message)); ?></strong>
													</span>
													<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
												</div>
											</div>
											<div class="col-md-12">
												<div class="form-group">
													<label for="security_answer"><?php echo app('translator')->get('Security answer'); ?></label>
													<input type="password" name="security_answer"
														   placeholder="<?php echo app('translator')->get('User security answer'); ?>"
														   value="<?php echo e(old('security_answer')); ?>"
														   class="form-control <?php $__errorArgs = ['security_answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
													<div
														class="invalid-feedback"><?php $__errorArgs = ['security_answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?>
														<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="form-group">
													<label for="address"><?php echo app('translator')->get('Address'); ?></label>
													<textarea
														class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
														name="address"
														rows="5"><?php echo e(old('address', $userProfile->address)); ?></textarea>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="form-group">
													<div class="custom-file">
														<input type="file" class="custom-file-input file-upload-input"
															   id="profile_picture" name="profile_picture">
														<label class="custom-file-label form-control-sm"
															   for="profile_picture"><?php echo app('translator')->get('Choose profile picture'); ?></label>
													</div>
												</div>
											</div>
										</div>
										<button type="submit"
												class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Update Profile'); ?></button>
									</form>
								</div>
							</div>
						</div>

						<div class="col-lg-5">
							<div class="card mb-4 card-primary shadow">
								<div class="card-body">
								<span class="py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="mb-1 font-weight-bold text-primary"><?php echo app('translator')->get('User Current Balance'); ?></h6>
									<a href="<?php echo e(route('admin.user.add.balance',$user->id)); ?>"
									   class="btn btn-sm btn-outline-primary"><i
											class="fas fa-plus"></i> <?php echo app('translator')->get('Add Balance'); ?></a>
								</span>
									<ul class="list-group">
										<?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<li class="list-group-item d-flex flex-row justify-content-between align-items-center">
										<span>
											<img class="image-profile rounded-circle"
												 src="<?php echo e(getFile(config('location.currencyLogo.path').optional($value->currency)->logo)); ?>">
											<?php echo e(__(optional($value->currency)->name)); ?> &nbsp;
										</span>
												<span>
											<?php echo e(__(optional($value->currency)->symbol) . ' ' . getAmount($value->balance)); ?>

										</span>
											</li>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</ul>
								</div>

								<div class="card-body">
									<h6 class="mb-2 font-weight-bold text-primary"><?php echo app('translator')->get('User Transaction Details'); ?></h6>
									<div class="list-group">
										<a href="<?php echo e(route('admin.user.transfer.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Send money'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['transfer'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.requestMoney.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Request money'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['requestMoney'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.exchange.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Exchange'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['exchange'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.redeem.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Redeem code'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['redeemCode'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.escrow.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Escrow'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['escrow'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.voucher.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Voucher money'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['voucher'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.invoice.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Invoice money'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['invoice'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.fund.add.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Fund add'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['fund'])); ?></span>
										</a>
										<a href="<?php echo e(route('admin.user.payout.show',$user->id)); ?>"
										   class="list-group-item list-group-item-action" target="_blank">
											<?php echo app('translator')->get('Payouts'); ?><span
												class="badge badge-primary float-right"><?php echo e(__($transactionCount['payout'])); ?></span>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
			$(document).on('change', '.file-upload-input', function () {
				let _this = $(this);
				let reader = new FileReader();
				reader.readAsDataURL(this.files[0]);
				reader.onload = function (e) {
					$('.img-profile-view').attr('src', e.target.result);
				}
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/user/show.blade.php ENDPATH**/ ?>