<?php $__env->startSection('page_title', __('Commission List')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Commission List'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Commission List'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('user.commission.search')); ?>" method="get">
									<?php echo $__env->make('user.referralBonus.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Commission List'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('From'); ?></th>
											<th><?php echo app('translator')->get('To'); ?></th>
											<th><?php echo app('translator')->get('Level'); ?></th>
											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Title'); ?></th>
											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Created time'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $commissionEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('Sender'); ?>"><?php echo e(__(optional($value->sender)->name) ?? __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Receiver'); ?>"><?php echo e(__(optional($value->receiver)->name) ?? __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Level'); ?>"><?php echo e(__($value->level)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('title'); ?>"><?php echo e(__($value->title)); ?></td>
												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->commission_amount))); ?></td>
												<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($commissionEntries->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/referralBonus/index.blade.php ENDPATH**/ ?>