<?php $__env->startSection('page_title', __('Store Fronts')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content" id="store" v-cloak>
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Store Fronts'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Store Fronts'); ?></div>
				</div>
			</div>
			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-12 col-lg-12">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush"
													id="data-table">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('SL.'); ?></th>
														<th><?php echo app('translator')->get('User'); ?></th>
														<th><?php echo app('translator')->get('Image'); ?></th>
														<th><?php echo app('translator')->get('Name'); ?></th>
														<th><?php echo app('translator')->get('Product'); ?></th>
														<th><?php echo app('translator')->get('Shipping Charge'); ?></th>
														<th><?php echo app('translator')->get('Status'); ?></th>
														<th><?php echo app('translator')->get('Delivery Note'); ?></th>
														<th><?php echo app('translator')->get('Copy Link'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
															<td data-label="<?php echo app('translator')->get('User'); ?>">
																<a href="<?php echo e(route('user.edit', $item->user_id)); ?>"
																   class="text-decoration-none">
																	<div class="d-lg-flex d-block align-items-center ">
																		<div class="mr-3"><img
																				src="<?php echo e(optional($item->user)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																				alt="user"
																				class="rounded-circle" width="35"
																				data-toggle="tooltip" title=""
																				data-original-title="<?php echo e(optional($item->user)->name?? __('N/A')); ?>">
																		</div>
																		<div
																			class="d-inline-flex d-lg-block align-items-center">
																			<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($item->user)->name?? __('N/A'),20)); ?></p>
																			<span
																				class="text-muted font-14 ml-1"><?php echo e('@'.optional($item->user)->username?? __('N/A')); ?></span>
																		</div>
																	</div>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Image'); ?>">
																<img class="img-store-custom"
																	 src="<?php echo e(getFile(config('location.store.path').$item->image)); ?>">
															</td>
															<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($item->name); ?></td>
															<td data-label="<?php echo app('translator')->get('Product'); ?>"><span
																	class="badge badge-info"><?php echo e($item->products_map_count); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Shipping Charge'); ?>">
																<?php if($item->shipping_charge == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Status'); ?>">
																<?php if($item->status == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Delivery Note'); ?>">
																<span
																	class="badge badge-success"><?php echo e(ucfirst($item->delivery_note)); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Copy Link'); ?>">
																<a href="javascript:void(0)"
																   @click.stop.prevent="copyTestingCode('<?php echo e(route('public.view',$item->link)); ?>')">
																	<i class="fas fa-link"></i>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a href="<?php echo e(route('admin.store.view',$item->id)); ?>"
																   class="btn btn-outline-primary btn-sm"><i
																		class="fa fa-eye"></i></a>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
	<?php echo $__env->make('user.store.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$('#data-table').dataTable({
				"aaSorting": [],
				"ordering": false
			});
		});

		$(document).on('click', '.deleteStore', function () {
			var route = $(this).data('route');
			$('.deleteStoreForm').attr('action', route);
		})

		var newApp = new Vue({
			el: "#store",
			data: {},
			mounted() {
			},
			methods: {
				copyTestingCode(copyText) {
					navigator.clipboard.writeText(copyText);
					Notiflix.Notify.Success('Link Copied');
				},
			},
		})
	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/store/storeList.blade.php ENDPATH**/ ?>