<?php $__env->startSection('page_title',__('Support Tickets')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Support Tickets'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Support Tickets'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('admin.ticket.search')); ?>" method="get">
									<div class="row">
										<div class="col-md-2">
											<div class="form-group">
												<input type="text" name="ticket" value="<?php echo e(@request()->ticket); ?>"
													   class="form-control form-control-sm" placeholder="<?php echo app('translator')->get('Ticket No'); ?>">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input type="text" name="email" value="<?php echo e(@request()->email); ?>"
													   class="form-control form-control-sm" placeholder="<?php echo app('translator')->get('Email'); ?>">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group search-currency-dropdown">
												<select name="status" class="form-control form-control-sm">
													<option value="-1" <?php echo e(@request()->status == '-1' ? 'selected' : ''); ?>><?php echo app('translator')->get('All Ticket'); ?></option>
													<option value="0" <?php echo e(@request()->status == '0' ? 'selected' : ''); ?>><?php echo app('translator')->get('Open Ticket'); ?></option>
													<option value="1" <?php echo e(@request()->status == '1' ? 'selected' : ''); ?>><?php echo app('translator')->get('Answered Ticket'); ?></option>
													<option value="2" <?php echo e(@request()->status == '2' ? 'selected' : ''); ?>><?php echo app('translator')->get('Replied Ticket'); ?></option>
													<option value="3" <?php echo e(@request()->status == '3' ? 'selected' : ''); ?>><?php echo app('translator')->get('Closed Ticket'); ?></option>
												</select>
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input type="date" class="form-control form-control-sm" name="date_time"
													   id="datepicker"/>
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<button type="submit" class="btn btn-sm btn-primary btn-block"><i
															class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Tickets'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center ">
										<thead>
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('User'); ?></th>
											<th><?php echo app('translator')->get('Subject'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Last Reply'); ?></th>
											<th><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="SL">
													<?php echo e(loopIndex($tickets) + $key); ?>

												</td>
												<td data-label="Submitted By">
													<?php if($ticket->user_id): ?>
														<a href="<?php echo e(route('user.edit', $ticket->user_id)); ?>" class="text-decoration-none"
														   target="_blank">
															<div class="d-lg-flex d-block align-items-center ">
																<div class="mr-3"><img src="<?php echo e(optional($ticket->user)->profilePicture()??asset('assets/upload/boy.png')); ?>" alt="user"
																					   class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e(optional($ticket->user)->name); ?>">
																</div>
																<div class="d-inline-flex d-lg-block align-items-center">
																	<p class="text-dark mb-0 font-16 font-weight-medium">
																		<?php echo e(Str::limit(optional($ticket->user)->name?? __('N/A'),20)); ?></p>
																	<span class="text-muted font-14 ml-1"><?php echo e('@'.optional($ticket->user)->username); ?></span>
																</div>
															</div>
														</a>
													<?php else: ?>
														<p class="font-weight-bold"> <?php echo e(__($ticket->name)); ?></p>
													<?php endif; ?>

												</td>

												<td data-label="Subject">
													<a href="<?php echo e(route('admin.ticket.view', $ticket->id)); ?>"
													   class="font-weight-bold" target="_blank">
														[<?php echo e(trans('Ticket#') . __($ticket->ticket)); ?>] <?php echo e(_($ticket->subject)); ?>

													</a>
												</td>

												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($ticket->status == 0): ?>
														<span class="badge badge-pill badge-primary"><?php echo app('translator')->get('Open'); ?></span>
													<?php elseif($ticket->status == 1): ?>
														<span class="badge badge-pill badge-success"><?php echo app('translator')->get('Answered'); ?></span>
													<?php elseif($ticket->status == 2): ?>
														<span class="badge badge-pill badge-dark"><?php echo app('translator')->get('Customer Replied'); ?></span>
													<?php elseif($ticket->status == 3): ?>
														<span class="badge badge-pill badge-danger"><?php echo app('translator')->get('Closed'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Last Reply'); ?>">
													<?php echo e($ticket->last_reply->diffForHumans()); ?>

												</td>
												<td data-label="Action">
													<a href="<?php echo e(route('admin.ticket.view', $ticket->id)); ?>"
													   class="btn btn-sm btn-outline-primary">
														<i class="fa fa-eye"> <?php echo app('translator')->get('View'); ?></i>
													</a>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($tickets->appends($_GET)->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/ticket/index.blade.php ENDPATH**/ ?>